import numpy as np
import pandas as pd

# datasets
data_path_excel = '/content/Neural Network Training Dataset Dawlish.xlsx'
data = pd.read_excel(data_path_excel)

# separate feature from our predictor variables
Xfeature_variables = data[['Hs', 'Freeboard (m CD)', 'Tm (s)', 'U10 Dir', 'Dm', 'Wind(m/s)']].values
ypredictor_variables = data['Wave Overtopping '].values

# Define the sigmoid function along with stochastic graident descent (see formula)
def sigmoid(x):
    return 1 / (1 + np.exp(-x))

def sigmoid_derivative(x):
    return sigmoid(x) * (1 - sigmoid(x))

# Neural Network class
class NeuralNetwork:
    def __init__(self, input_size, learning_rate=0.1):
        # this is telling us to randomly assign weights and bias values, remember during stochastic gradient descent these will be updated to minimise the loss function
        self.weights = np.random.randn(input_size)
        self.bias = np.random.randn()
        self.learning_rate = learning_rate

    def predict(self, input_vector):
        layer_1_output = np.dot(input_vector, self.weights) + self.bias
        # sigmoid activation function
        return sigmoid(layer_1_output)

    def train(self, input_vectors, targets, iterations):
        for _ in range(iterations):
            for input_vector, target in zip(input_vectors, targets):
                prediction = self.predict(input_vector)
                # The prediction error is then calculated
                error = target - prediction
                # this is gradient descent updating the values
                self.weights += self.learning_rate * error * input_vector * sigmoid_derivative(prediction)
                self.bias += self.learning_rate * error * sigmoid_derivative(prediction)

# train the neural network, the number of iterations can be adjusted after systematic grid searches
input_size = Xfeature_variables.shape[1]
nn = NeuralNetwork(input_size=input_size)
nn.train(Xfeature_variables, ypredictor_variables, iterations=1000)

# test the neural network performance
test_index = 0
test_input = Xfeature_variables[test_index]
test_prediction = nn.predict(test_input)
print("Probability of overtopping as a % confidence):", test_prediction)